      IMPLICIT REAL*8(A-H,O-Z)
      CALL SUB1
      STOP
      END
C**********************************************************************
C
C   THMIN = Opening angle of ring (the one-sided angle, total angle is
C                                  twice this value !)
C
C   nline = number of lines
C   nshell = number of shells
C   nuvshl = number of 'optically thin' shells
C   iline = line of current interest
C   weight = fraction of shells which are 'optically thick'
C   program calculates flux in 1E-13 erg s-1 cm-2 for D = 50 kpc
C
C**********************************************************************
      SUBROUTINE SUB1
      IMPLICIT REAL*8(A-H,O-Z)
      real*8 mu
      character*80 file1,file2,file3
C
      common/phexc/sint(3001)
C
      dimension atest(170),radius(80),wrsum(80,35),iline(35),
     &wwsum(4001,35),ttii(80),te(80,80),den(80),denz(10),nz(10),
     &fny(35),fnyold(35),totemp(80,35,80),tlum(35,80),
     &pesct(2,80,80),pesum(2,80),ppp(2),pesc(2,80),totlum(80,80)
C
      OPEN(13,FILE='readxd2_1e2')
      read(13,99)file1
      read(13,99)file2
      read(13,99)file3
      READ(13,*)NUM,ALPHA,BETA,THMIN,ifirst
      open(14,FILE=file1)
      open(7,FILE=file2)
      open(6,FILE=file3)
      read(13,*)nline,nshell,(iline(iq),iq=1,20),weight,radf
      read(13,*)nstart,nend,ifmax
   99 format(a)
C
      do ipp=1,20
       fny(ipp)=0.0d0
       fnyold(ipp)=0.0d0
         do ipqf=1,51
         wrsum(ipqf,ipp)=0.0d0
         enddo
      enddo
      do ipp=1,80
       radius(ipp)=0.0d0
       ttii(ipp)=0.0d0
       do ipq=1,80
        te(ipq,ipp)=0.0d0
        totlum(ipq,ipp)=0.0d0
       enddo
      enddo
      PI=3.14159265358979D0
      mu=dcos((pi*alpha)/1.8d2)
      c=2.998d10
      day=8.64d4
      frainp=pi*(0.5d0-thmin/180.d0)
      fracv=(1.6d-34*pi**2*dcos(frainp))/3.d0
      fracv=3.3424d0*fracv
       do 9890 ijl=1,nshell+1
       read(7,*)radius(ijl)
       radius(ijl)=1.d15*radius(ijl)
 9890  continue
      rf=radf*0.5d0*(radius(nstart)+radius(nend+1))
      itest=200
       do 8888 ijk=1,itest
       read(14,*,err=999,end=999)ttii(ijk)
       ttii(ijk)=day*ttii(ijk)
        do 8890 ijl=1,nshell
        fracv2=(radius(ijl+1)**3-radius(ijl)**3)
        read(14,*,err=999,end=999)te(ijk,ijl),
     &                            (atest(ijm),ijm=1,nline)
         do 6761 ijq=1,20
         totemp(ijk,ijq,ijl)=fracv2*fracv*atest(iline(ijq))
 6761    continue
 8890   continue
       ntime=ijk
 8888  continue
  999 continue
C
      ifmax=nend-nstart+1
      DO ifud=1,ifmax
      ifudd=ifud-1+nstart
      rf=0.5d0*(radius(ifudd)+radius(ifudd+1))
      rc=rf/c
	do ijk=1,ntime
	  do ijq=1,20
	  totlum(ijk,ijq)=totemp(ijk,ijq,ifudd)
	  enddo
	enddo
      tmin=rc*(1.d0-mu)
      tmax=rc*(1.d0+mu)
      do 100 it=1,3200
       do 3467 k=1,20
       fny(k)=0.0d0
       fnyold(k)=0.0d0
 3467  wrsum(ifud,k)=0.0d0
      TIME=2.5D0*DAY*DBLE(IT-1)
      if(time.lt.tmin) goto 1999
      t2=dmin1(time,tmax)
      qqq=(1.d0-t2/rc)/mu
      if(qqq.le.-1.d0) qqq=-1.d0
      if(qqq.ge.1.d0) qqq=1.d0
      xlmax=rf*dacos(qqq)
      nt=idnint((1.d3*xlmax)/rf+0.5d0)
      if(nt.le.10) nt=10
      dxl=xlmax/dble(nt)
       do 1000 i=1,nt+1
       xli=dxl*dble(i-1)
       phi=xli/rf
       if(phi.lt.(pi/2.d0)) then
	 beta=pi/2.d0-dacos(dcos(phi)*mu)
       else
	 beta=pi/2.d0-dacos(dcos(pi-phi)*mu)
       endif
       ti=rc*(1.d0-mu*dcos(xli/rf))
       tint=time-ti
       if(tint.le.8.64d4) tint=8.64d4
        do 1001 ni=ntime,2,-1
        nu=ni
        if(tint.gt.ttii(ni-1).and.tint.lt.ttii(ni)) goto 1002
 1001   continue
 1002  continue
       at2=(ttii(nu)-tint)/(ttii(nu)-ttii(nu-1))
       at1=1.d0-at2
        do 1003 k=1,20
        fny(k)=at1*totlum(nu,k)+at2*totlum(nu-1,k)
	fny(k)=fny(k)/(pi*rf)
        if(i.ne.1) wrsum(ifud,k)=wrsum(ifud,k)+0.5d0*dxl*
     &                  	(fny(k)+fnyold(k))
        fnyold(k)=fny(k)
 1003   continue
 1000  continue
 1999 continue
	do k=1,20
	if(ifud.eq.1) wwsum(it,k)=0.0d0
	wwsum(it,k)=wwsum(it,k)+wrsum(ifud,k)
	enddo
      if(ifud.eq.ifmax) then
        WRITE(6,200)(TIME/8.64D4),(wwsum(it,k),k=1,20)
      endif
  100 CONTINUE
      enddo
  200 FORMAT(1X,120E13.5)
C
      RETURN
      END
C************************************************************           
C************************************************************           
      SUBROUTINE SIMPA(N,H,S)                                           
      IMPLICIT REAL*8(A-H,O-Z)                                          
      COMMON/PHEXC/F(3001)
C     OBS! N MUST BE AN ODD NUMBER                                      
      NC=N-1                                                            
      ND=N-2                                                            
      NA=N+1                                                            
      NB=N-3                                                            
      SUM4=0.                                                           
      SUM2=0.                                                           
      DO 120 I=2,NC,2                                                   
  120 SUM4=SUM4+F(I)                                                    
      DO 130 I=3,ND,2                                                   
  130 SUM2=SUM2+F(I)                                                    
  320 S=H*(4.*SUM4+2.*SUM2+F(1)+F(N))/3.                                
      RETURN                                                            
      END                                                               
c*********************************************************************   
