! skysub.prg
!
! input: catalog with input NOTCam fits images
!	 sky image
!	normalised flat field
! output: catalog with sky-subtracted and flatfielded images, 
! normalised to 1s exposure time
!
! It is possible to change between using median and mode by
! changing statistic(12) to statistic(8) or vice versa
!
define/para p1 ? ima "Enter input image"
define/para p2 ? ima "Enter output image"
define/para p3 ? ima "Enter input sky frame"
define/para p4 ? ima "Enter flatfield frame"
define/local inimage/c/1/60 {p1} 
define/local outimage/c/1/60 {p2} 
define/local insky/c/1/60 {p3}  
define/local inflat/c/1/60 {p4}
define/local skyscale/r/1/1 0
define/local exptime/r/1/1 0
define/local bl/r/1/1 0
define/local bh/r/1/1 0
STAT/IMA {insky} [@100,@100:@900,@900] #1024 OPTION=G
@@ statfitcube.prg {inimage}
comp/key skyscale = {{inimage},statistic(8)}/{{insky},statistic(8)}
comp/key exptime = {{inimage},O_TIME(7)}
write/out {exptime} {skyscale}
COMP/IMA {outimage} = ({inimage} - {skyscale}*{insky})/{exptime}/{inflat}

